package adf.sample.model.vo;


import adf.sample.model.vo.common.EmployeesView;

import oracle.jbo.Row;
import oracle.jbo.RowSet;
import oracle.jbo.server.ViewObjectImpl;
// ---------------------------------------------------------------------
// ---    File generated by Oracle ADF Business Components Design Time.
// ---    Thu Mar 01 21:26:59 CET 2012
// ---    Custom code may be added to this class.
// ---    Warning: Do not modify method signatures of generated methods.
// ---------------------------------------------------------------------
public class EmployeesViewImpl extends ViewObjectImpl implements EmployeesView {
    /**
     * This is the default constructor (do not remove).
     */
    public EmployeesViewImpl() {
    }
    
    /**
     * Sample method that if invoked deletes all rows that have the 
     * MarekedForDelete transient attribute set to true
     */
    public void deleteSelectedRows(){
        //create a second row set to not impact the row set
        //used in ADF
        RowSet duplicateRowSet = this.createRowSet("duplicateRowSet");
        //set rowset to first row to avoid "attempt to access
        //dead row" exception
        duplicateRowSet.first();
        //get the current row of the table to set it back after
        //re-executing the VO
        Row currentRow = this.getCurrentRow();
        boolean currentRowDeleted = false;
        //get all rows that have the transoent attribute "MarkForDelete" set to
        //true
        Row[] rowsToDelete = duplicateRowSet.getFilteredRows("MarkedForDelete", true);
        if (rowsToDelete.length>0) {
            //only run throizgh this code if there is something to 
            //delete
            for (Row rw : rowsToDelete) {
                //if row is ts marked as the current in VO, set
                //boolean flag
                if (rw.getKey().equals(currentRow.getKey())) {
                    currentRowDeleted = true;
                }
                //remove row - don't yet commit
                rw.remove();
            }
            //re-execute VO
            this.executeQuery();
            //reset current row if it hasn't been deleted
            if (!currentRowDeleted) {
                this.setCurrentRow(currentRow);
            }
            duplicateRowSet.closeRowSet();
        }
    }
}
